<?php
namespace Core;
class Router {
    private $routes = [];
    public function addRoute($path, $file) {
        $this->routes[$path] = $file;
    }
    public function route() {
        $request = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
        if (isset($this->routes[$request])) {
            $file = $this->routes[$request];
        }
        else if ($request === '' || $request === 'router.php' || $request === 'index') {
            $file = 'index.php';
        }
        else {
            $file = $request . '.php';
        }
        if (file_exists($file)) {
            include $file;
        } else {
            header("Location: https://google.com");
            exit;
        }
    }
}
?>
